<?php

namespace App\Repositories;

use App\Models\PurchaseOrder;
use App\Models\PurchaseOrderLine;
use Illuminate\Support\Collection;

class PurchaseOrderLineRepository
{
    public function getPurchaseOrderLinesWithCostFromIds(PurchaseOrder $purchaseOrder, array $purchaseOrderLineIds): Collection
    {
        return PurchaseOrderLine::whereIn('purchase_order_lines.id', $purchaseOrderLineIds)
            ->withCostValues($purchaseOrder->id)
            ->get();
    }

    public function getUnderReceivedLinesForPurchaseOrder(PurchaseOrder $purchaseOrder): Collection
    {
        return PurchaseOrderLine::where('purchase_order_id', $purchaseOrder->id)
            ->whereNotNull('product_id')
            ->whereColumn('quantity', '>', 'received_quantity')
            ->get();
    }

    public function getOverReceivedLinesForPurchaseOrder(PurchaseOrder $purchaseOrder): Collection
    {
        return PurchaseOrderLine::where('purchase_order_id', $purchaseOrder->id)
            ->whereNotNull('product_id')
            ->whereColumn('quantity', '<', 'received_quantity')
            ->get();
    }
}
