<?php

namespace App\Repositories;

use App\Models\ProductPricingTier;

class ProductPricingTierRepository
{
    public function getDefault($useCache = false): ProductPricingTier
    {
        $query = function () {
            return ProductPricingTier::where('is_default', true)->first();
        };

        return $useCache ? cache()->remember('product_pricing_tier_default', 120, $query) : $query();
    }

}