<?php

namespace App\Repositories;

use App\Abstractions\AbstractRepository;
use App\Collections\ProductAttributeCollection;
use App\Models\ProductAttribute;

class ProductAttributeRepository extends AbstractRepository
{
    public function __construct()
    {
    }

    public function saveBulk(ProductAttributeCollection $data, bool $insert, bool $update, $metadata): array
    {
        $tempTable = ProductAttribute::dataFeedBulkImport([
            'data_to_import' => [
                'type' => 'json',
                'data' => $data->toJson(),
            ],
            'insert' => $insert,
            'update' => $update,
            'mappings' => [
                [
                    'joins' => [
                        [
                            'table' => 'products',
                            'type' => 'leftJoin',
                            'on' => [
                                [
                                    'database_column' => 'sku',
                                    'stage_column_to_join' => 'sku',
                                ],
                            ],
                            'column_type' => 'integer',
                            'add_select' => [
                                [
                                    'expected_column_name' => 'product_id',
                                    'data_column_name' => 'id',
                                    'expected_column_type' => 'integer',
                                    'is_importable' => true,
                                ],

                            ],
                        ],
                    ],
                ],
                [
                    'expected_column_name' => 'sku',
                    'data_column_name' => 'sku',
                    'expected_column_type' => 'text',
                    'is_importable' => false,
                ],
                [
                    'expected_column_name' => 'value',
                    'data_column_name' => 'value',
                    'expected_column_type' => 'text',
                ],
                [
                    'expected_column_name' => 'attribute_id',
                    'data_column_name' => 'attribute_id',
                    'expected_column_type' => 'integer',
                ],
            ],
            'default_columns' => [
                [
                    'expected_column_name' => 'created_at',
                    'default_value' => now(),
                    'expected_column_type' => 'datetime',
                ],
                [
                    'expected_column_name' => 'updated_at',
                    'default_value' => now(),
                    'expected_column_type' => 'datetime',
                ],
            ],
            'unique_by_columns' => [
                'product_id',
                'attribute_id',
            ],
        ]);

        return [
            'temp_table' => $tempTable,
            'status' => true,
        ];
    }
}
