<?php

namespace App\Repositories;

use App\DTO\PaymentTypeData;
use App\Models\PaymentType;
use Illuminate\Database\Eloquent\Collection as EloquentCollection;

class PaymentTypeRepository
{
    public function save(PaymentTypeData $data): PaymentType
    {
        return PaymentType::updateOrCreate([
            'name' => $data->name,
        ],
            $data->toArray()
        );
    }

    public function deletePaymentTypeByName(string $paymentType): ?PaymentType
    {
        return PaymentType::where([
            'name' => $paymentType,
        ])
            ->delete();
    }

    public function getFromNames(array $names): EloquentCollection
    {
        return PaymentType::whereIn('name', $names)
            ->get();
    }
}
