<?php

namespace App\Repositories;

use App\Models\Currency;

class CurrencyRepository
{
    public function getDefault($useCache = false): Currency
    {
        $query = function () {
            return Currency::where('is_default', true)->first();
        };

        return $useCache ? cache()->remember('currency_default', 120, $query) : $query();
    }

    public function getCurrencyRateFromId(int $currencyId, $useCache = false): float
    {
        $query = function () use ($currencyId) {
            return Currency::where('id', $currencyId)->first()->conversion;
        };

        return $useCache ? cache()->remember("currency_rate_{$currencyId}", 120, $query) : $query();
    }

}