<?php

namespace App\Repositories;

use App\Models\ApiLog;
use Carbon\Carbon;

class ApiLogRepository
{
    public function deleteLogsOlderThan(int $days): void
    {
        // Calculate the date 7 days ago
        $sevenDaysAgo = Carbon::now()->subDays($days);

        // Delete the records older than 7 days
        ApiLog::query()->where('created_at', '<', $sevenDaysAgo)->delete();
    }
}
