<?php

namespace App\Queries\Magento;

use Illuminate\Support\Facades\DB;

class UpdateInventoryCache
{
    public static function execute($data, $salesChannelId)
    {
        if (empty($data)) {
            return;
        }

        $sqlTempTable = 'CREATE TEMPORARY TABLE tempInventoryUpdates (`product_listing_id` bigint, `qty` double(8,2), last_updated datetime, PRIMARY KEY (`product_listing_id`)) ENGINE=InnoDB;';

        $sqlInsert = 'INSERT INTO tempInventoryUpdates VALUES '.implode(',', $data).';';

        $sqlUpdate = 'UPDATE `product_listings` AS pl INNER JOIN tempInventoryUpdates AS tiu ON tiu.product_listing_id = pl.id
            SET pl.sales_channel_qty = tiu.qty, pl.sales_channel_qty_last_updated = tiu.last_updated';

        DB::statement($sqlTempTable);
        DB::insert($sqlInsert);

        return DB::update($sqlUpdate);
    }
}
