<?php

namespace App\Providers;

use App\Http\Middleware\WebhookAuthenticate;
use Illuminate\Cache\RateLimiting\Limit;
use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\RateLimiter;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Str;

class RouteServiceProvider extends ServiceProvider
{
    /**
     * The path to the "home" route for your application.
     *
     * @var string
     */
    public const HOME = '/home';

    /**
     * Define your route model bindings, pattern filters, etc.
     */
    public function boot(): void
    {
        $this->routes(function () {
            //        $this->mapMockRoutes();

            $this->mapApiRoutes();

            $this->mapWebRoutes();

            //
        });
        RateLimiter::for('api', function (Request $request) {
            return Limit::perMinute(60)->by($request->user()?->id ?: $request->ip());
        });

        /**
         * Add a new function to Route Facade (skuResource).
         */
        Route::macro('skuResource', function (string $prefix, string $controller, ?string $modelName = null, ?callable $callback = null) {
            // default model name from prefix (snake case)
            if (! $modelName) {
                $modelName = Str::singular(Str::snake(Str::camel($prefix)));
            }

            Route::prefix($prefix)->as("{$prefix}.")->group(function () use ($callback, $controller, $modelName, $prefix) {
                Route::put("{{$modelName}}/archive", "{$controller}@archive")->name('archive');
                Route::put("{{$modelName}}/unarchived", "{$controller}@unarchived")->name('unarchived');

                // add any additional routes
                if ($callback) {
                    $callback();
                }

                // bulk
                Route::put('/archive', "{$controller}@bulkArchive")->name("{$prefix}-bulk-archive");
                Route::put('/unarchive', "{$controller}@bulkUnArchive")->name('bulk-unarchive');
                Route::delete('/', "{$controller}@bulkDestroy")->name('bulk-delete');
                Route::post('deletable', "{$controller}@isDeletable")->name('deletable');
            });

            Route::resource($prefix, $controller)->except(['create', 'edit']);
        });
    }

    /**
     * Define the "web" routes for the application.
     *
     * These routes all receive session state, CSRF protection, etc.
     */
    protected function mapWebRoutes(): void
    {
        Route::middleware('web')
            ->group(base_path('routes/web.php'));
        Route::middleware(['web', 'auth'])
            ->group(base_path('routes/exports.php'));
    }

    /**
     * Define the "api" routes for the application.
     *
     * These routes are typically stateless.
     */
    protected function mapApiRoutes(): void
    {
        Route::prefix('api')
            ->middleware('api')
            ->group(base_path('routes/api.php'));

        /**
         * Load Vue.js routes.
         */
        Route::prefix('api')
            ->middleware('api')
            ->group(base_path('routes/api/internal_application.php'));

        /**
         * Load customer api routes.
         */
        Route::prefix('api')
            ->middleware('api')
            ->group(base_path('routes/api/user.php'));

        /**
         * Load routes for webhooks.
         */
        Route::prefix('api/webhooks')
            // Webhook authentication is temporarily disabled.
//            ->middleware(WebhookAuthenticate::class)
            ->name('webhooks.')
            ->group(base_path('routes/webhook.php'));
    }

    /**
     * Define the "mock" routes for the application.
     *
     * These routes are typically stateless.
     */
    protected function mapMockRoutes(): void
    {
        Route::prefix('mock')
            ->middleware('api')
            ->group(base_path('routes/mock.php'));
    }
}
