<?php

namespace App\Providers;

use Illuminate\Support\Facades\Route;
use Illuminate\Support\ServiceProvider;

class IntegrationServiceProvider extends ServiceProvider
{
    public function register(): void
    {
        Route::macro('salesChannel', function (
            $name,
            $productController,
            $orderController,
            $fulfillmentController,
            $authenticationController,
            $integrationInstanceController,
        ) {
            Route::prefix("$name/{integrationInstance}")->name("$name.")->group(function () use (
                $productController,
                $orderController,
                $fulfillmentController,
                $authenticationController
            ) {
                Route::controller($productController)->prefix('products')->name('products.')->group(function () {
                    Route::post('create-sku-products', 'createSkuProducts')->name('create-sku-products');
                    Route::post('refresh', 'refresh')->name('refresh');
                    Route::put('map', 'mapProducts')->name('map');
                    Route::get('export', 'exportForIntegration')->name('export');
                    Route::post('import-mappings', 'importMappings')->name('import-mappings');
                    Route::post('sync-inventory', 'syncInventory')->name('sync-inventory');
                    Route::post('hydrate-product-template', 'hydrateProductTemplate')->name('hydrate-product-template');
                    Route::get('/', 'indexForIntegration')->name('index');
                });
                Route::apiResource('/products', $productController)->parameters(['products' => 'product'])->except('index');
                Route::controller($orderController)->prefix('orders')->name('orders.')->group(function () {
                    Route::post('create-sku-orders', 'createSkuOrders')->name('create-sku-orders');
                    Route::post('refresh', 'refresh')->name('refresh');
                    Route::post('refresh-order', 'refreshOrder')->name('refresh-order');
                    Route::get('export', 'exportForIntegration')->name('export');
                    Route::get('/', 'indexForIntegration')->name('index');
                });
                Route::apiResource('/orders', $orderController)->parameters(['orders' => 'order'])->except('index');
                Route::post('/fulfill', $fulfillmentController)->name('fulfill');
                Route::get('get-redirect-url', [$authenticationController, 'getRedirectUrl'])->name('get-redirect-url');
            });
            Route::apiResource($name, $integrationInstanceController)->parameters([$name => 'integrationInstance']);
        });

        Route::macro('accounting', function (
            $name,
            $authenticationController,
            $accountController,
            $taxRateController,
            $vendorController,
            $accountingTransactionController
        ) {
            Route::prefix("$name/{integrationInstance}")->name("$name.")->group(function () use ($accountController, $taxRateController, $vendorController, $accountingTransactionController, $authenticationController) {
                //Accounts
                Route::controller($accountController)->prefix('accounts')->name('accounts.')->group(function () {
                    Route::post('refresh', 'refresh')->name('refresh');
                    Route::post('create-nominal-codes', 'createNominalCodes')->name('create-nominal-codes');
                    Route::get('/', 'indexForIntegration')->name('index');
                });

                //Tax Rates
                Route::controller($taxRateController)->prefix('tax-rates')->name('tax-rates.')->group(function () {
                    Route::post('refresh', 'refresh')->name('refresh');
                    Route::get('/', 'indexForIntegration')->name('index');
                });

                //Vendors
                Route::controller($vendorController)->prefix('vendors')->name('vendors.')->group(function () {
                    Route::post('sync', 'sync')->name('sync');
                    Route::get('/', 'indexForIntegration')->name('index');
                });

                //Transactions - Purchase Orders, Bills, Sales Orders
                Route::controller($accountingTransactionController)->prefix('transactions')->name('transactions.')->group(function () {
                    Route::post('sync-transactions', 'syncTransactions')->name('syncTransactions');
                    Route::post('sync-payments', 'syncPayments')->name('syncPayments');
                    Route::post('delete-payments', 'deletePayments')->name('deletePayments');
                });

                Route::get('get-redirect-url', [$authenticationController, 'getRedirectUrl'])->name('get-redirect-url');
            });
        });
    }
}
