<?php

namespace App\Providers;

use App\Models\SalesOrderFulfillment;
use App\Services\SalesOrder\Fulfillments\Dispatchers\ShipstationDispatcher;
use App\Services\SalesOrder\Fulfillments\Dispatchers\StarshipitDispatcher;
use Illuminate\Support\ServiceProvider;
use Modules\Amazon\Services\AmazonOutboundDispatcher;
use Modules\ShipMyOrders\Managers\ShipMyOrdersDispatchManager;
use Modules\Veracore\Services\Fulfillments\VeracoreDispatcher;

class FulfillmentServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        // Bind shipping provider dispatchers
        $this->app->singleton(SalesOrderFulfillment::TYPE_STARSHIPIT, StarshipitDispatcher::class);
        $this->app->singleton(SalesOrderFulfillment::TYPE_SHIPSTATION, ShipstationDispatcher::class);
        $this->app->singleton(SalesOrderFulfillment::TYPE_SHIPMYORDERS, ShipMyOrdersDispatchManager::class);
        $this->app->singleton(SalesOrderFulfillment::TYPE_VERACORE, VeracoreDispatcher::class);
        $this->app->singleton(SalesOrderFulfillment::TYPE_FBA, AmazonOutboundDispatcher::class);
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
    }
}
