<?php

namespace App\Observers;

use App\Models\SalesOrderLine;
use App\Repositories\SalesOrderLineFinancialsRepository;

class SalesOrderLineFinancialObserver
{
    public function created(SalesOrderLine $salesOrderLine): void
    {
        if ($salesOrderLine->salesOrderLineFinancial) {
            return;
        }

        if (config('app.env') !== 'testing') {
            // Not sure exactly why this is needed.  We are going to seed the financial line in the next step so it should be ok.
            //customlog('sales_order_line_model', 'Sales Order Line Model creation directly used outside testing: ' . debug_pretty_string());
        }

        app(SalesOrderLineFinancialsRepository::class)->seedFromSalesOrderLine($salesOrderLine);
    }
}
