<?php

namespace App\Observers;

use App\Abstractions\IsLineInterface;
use App\Models\InventoryMovement;

class InventoryMovementUpdateObserver
{
    public function updated(InventoryMovement $inventoryMovement): void
    {
        if ($inventoryMovement->link_type != 'initial_count' && $inventoryMovement->link instanceof IsLineInterface) {
            $parent = $inventoryMovement->link->getLineParent();
            $parent->refresh()->update(['updated_at' => now()]);
        }
    }
}
