<?php

namespace App\Observers;

use App\Enums\AccountingTransactionTypeEnum;
use App\Models\AccountingTransaction;
use App\Models\PurchaseOrder;
use App\Models\WarehouseTransfer;

class AccountingTransactionObserver
{
    public function deleted(AccountingTransaction $accountingTransaction): void
    {
        if ($accountingTransaction->type == AccountingTransactionTypeEnum::RECEIVING_DISCREPANCY->value) {
            if ($accountingTransaction->link instanceof PurchaseOrder) {
                /** @var PurchaseOrder $purchaseOrder */
                $purchaseOrder = $accountingTransaction->link;
                $purchaseOrder->refreshReceiptStatus();
            }
            if ($accountingTransaction->link instanceof WarehouseTransfer) {
                /** @var WarehouseTransfer $warehouseTransfer */
                $warehouseTransfer = $accountingTransaction->link;
                // TODO: In future use something like refreshReceiptStatus, for now we are making status assumptions
                $warehouseTransfer->transfer_status = WarehouseTransfer::TRANSFER_STATUS_OPEN;
                $warehouseTransfer->receipt_status = WarehouseTransfer::TRANSFER_RECEIPT_STATUS_PARTIALLY_RECEIVED;
                $warehouseTransfer->save();
            }
        }
    }
}
