<?php

namespace App\Observers;

use App\Models\Supplier;
use App\Repositories\IntegrationInstanceRepository;
use Exception;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Arr;
use Modules\Xero\Jobs\XeroSyncSuppliersJob;

class AccountingObserver
{
    private IntegrationInstanceRepository $integrationInstanceRepository;

    public function __construct()
    {
        $this->integrationInstanceRepository = app(IntegrationInstanceRepository::class);
    }

    /**
     * @throws Exception
     */
    public function created(Model $model): void
    {
        if ($model instanceof Supplier) {
            if ($this->integrationInstanceRepository->getAccountingInstance()?->isXero()) {
                dispatch(new XeroSyncSuppliersJob(Arr::wrap($model->id)));
            }
        }
    }

    /**
     * @throws Exception
     */
    public function updated(Model $model): void
    {
        if ($model instanceof Supplier) {
            if ($this->integrationInstanceRepository->getAccountingInstance()?->isXero()) {
                dispatch(new XeroSyncSuppliersJob(Arr::wrap($model->id)));
            }
        }
    }

    public function deleted(Model $model): void
    {
    }
}
