<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class SendSalesOrderPackingSlipNotification extends Notification implements ShouldQueue
{
    use Queueable;

    public function __construct(private int $salesOrdersCount, private string $file)
    {
    }

    public function via($notifiable): array
    {
        return ['mail'];
    }

    public function toMail($notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject("Packing slips for {$this->salesOrdersCount} sales orders ready to download")
            ->line('Your export is ready to download.')
            ->action('Download the file', $this->file);
    }

    public function toArray($notifiable): array
    {
        return [];
    }
}
