<?php

namespace App\Notifications;

use App\Models\PurchaseOrder;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\BroadcastMessage;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class PurchaseOrderSent extends Notification implements ShouldQueue
{
    use Queueable;

    /**
     * @var PurchaseOrder
     */
    public $purchaseOrder;

    /**
     * Create a new notification instance.
     */
    public function __construct(PurchaseOrder $purchaseOrder)
    {
        $this->purchaseOrder = $purchaseOrder;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     */
    public function via($notifiable): array
    {
        return ['broadcast', 'mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     */
    public function toMail($notifiable): MailMessage
    {
        return ( new MailMessage )
            ->greeting('Hello '.$notifiable->name.'!')
            ->subject('Purchase Order Sent')
            ->line('Purchase Order sent to supplier.')
            ->action('View Purchase Order', url('/purchase-orders/'.$this->purchaseOrder->id))
            ->line('Thank you for using our application!');
    }

    /**
     * Get the broadcastable representation of the notification.
     *
     * @param  mixed  $notifiable
     */
    public function toBroadcast($notifiable): BroadcastMessage
    {
        return new BroadcastMessage([
            'title' => 'Purchase Order Send',
            'user' => auth()->user(),
            'url' => url('/purchase-orders/'.$this->purchaseOrder->id),
        ]);
    }
}
