<?php

namespace App\Notifications;

use App\Models\InventoryMovement;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\BroadcastMessage;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class InventoryReceived extends Notification implements ShouldQueue
{
    use Queueable;

    /**
     * @var InventoryMovement
     */
    public $inventoryMovement;

    /**
     * Create a new notification instance.
     */
    public function __construct(InventoryMovement $inventoryMovement)
    {
        $this->inventoryMovement = $inventoryMovement;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     */
    public function via($notifiable): array
    {
        return ['broadcast', 'mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     */
    public function toMail($notifiable): MailMessage
    {
        return ( new MailMessage )
            ->greeting('Hello '.$notifiable->name.'!')
            ->subject('Inventory Received')
            ->line('Product('.$this->inventoryMovement->product->sku.') received new quantity.')
            ->action('View Product', url('/products/'.$this->inventoryMovement->product_id))
            ->line('Thank you for using our application!');
    }

    /**
     * Get the broadcastable representation of the notification.
     */
    public function toBroadcast(mixed $notifiable): BroadcastMessage
    {
        return new BroadcastMessage([
            'title' => 'Inventory Received',
            'user' => auth()->user(),
            'url' => url('/products/'.$this->inventoryMovement->product_id),
        ]);
    }
}
