<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class FulfillSalesOrdersNotification extends Notification implements ShouldQueue
{
    use Queueable;

    protected ?string $attachment;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct(?string $attachment = null)
    {
        $this->attachment = $attachment;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     */
    public function via($notifiable): array
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     */
    public function toMail($notifiable): MailMessage
    {
        $mail = (new MailMessage)
            ->subject('Sales Order Fulfilled')
            ->greeting("Hello {$notifiable->name}.")
            ->line('Your sales orders fulfilled successfully.');

        if (! empty($this->attachment)) {
            $mail->attachData($this->attachment, 'Fulfill Errors.txt', [
                'mime' => 'text/plain',
            ]);
        }

        return $mail;
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     */
    public function toArray($notifiable): array
    {
        return [
            //
        ];
    }
}
