<?php

namespace App\Notifications;

use App\Models\SalesOrder;
use App\Models\StoreEmailTemplate;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use ReflectionClass;

class EmailTemplateNotification extends Notification implements ShouldQueue
{
    use Queueable;

    public function __construct(
        private SalesOrder|Model $order,
        private string $subject,
        private string $body,
        private array $cc,
        private string $from
    )
    {
    }

    public function via($notifiable): array
    {
        return ['mail'];
    }

    public function toMail($notifiable): MailMessage
    {
        $type = (new ReflectionClass($this->order))->getShortName();

        $data = StoreEmailTemplate::fillTemplate($this->order->id, $type, $this->subject,
            $this->body);

        $mail = (new MailMessage)
            ->subject($data['subject'])
            ->from($this->from)
            ->view('mail.template', ['body' => $data['body']]);

        if ($this->cc && count($this->cc)) {
            $mail->cc($this->cc);
        }

        return $mail;
    }

    public function toArray($notifiable): array
    {
        return [];
    }
}
