<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class UserAlertSetting.
 *
 *
 * @property int $id
 * @property int $user_id
 * @property string $alert_type
 * @property bool $show_in_ui_notification
 * @property bool $alert_by_email
 * @property int $priority
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 */
class UserAlertSetting extends Model
{
    const ALERT_TYPE_PO_DRAFT_CREATED = 'Purchase Order Draft Created';

    const ALERT_TYPE_PO_APPROVED = 'Purchase Order Draft Approved';

    const ALERT_TYPE_PO_SENT = 'Purchase Order Sent';

    const ALERT_TYPE_PO_MODIFIED = 'Purchase Order Modified';

    const ALERT_TYPE_PI_CREATED = 'Purchase Invoice Created';

    const ALERT_TYPE_INVENTORY_RECEIVED = 'Inventory Received';

    const ALERT_TYPE_RECLASSIFICATION = 'Reclassification';

    const ALERT_TYPE_SC_LISTING_LINKED = 'Sales Channel Listing Linked';

    const ALERT_TYPES = [
        self::ALERT_TYPE_PO_DRAFT_CREATED,
        self::ALERT_TYPE_PO_APPROVED,
        self::ALERT_TYPE_PO_SENT,
        self::ALERT_TYPE_PO_MODIFIED,
        self::ALERT_TYPE_PI_CREATED,
        self::ALERT_TYPE_INVENTORY_RECEIVED,
        self::ALERT_TYPE_RECLASSIFICATION,
        self::ALERT_TYPE_SC_LISTING_LINKED,
    ];

    /*
    |--------------------------------------------------------------------------
    | Relations
    |--------------------------------------------------------------------------
    */

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
