<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class TableView.
 *
 *
 * @property int $id
 * @property string $name
 * @property string $model
 * @property array $content
 * @property bool $is_favorite
 * @property bool $is_default
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property Carbon|null $deleted_at
 */
class TableView extends Model
{
    use SoftDeletes;

    protected $casts = [
        'content' => 'array',
        'is_favorite' => 'boolean',
        'is_default' => 'boolean',
    ];

    protected $fillable = ['name', 'model', 'content', 'is_favorite', 'is_default'];

    public function save(array $options = [])
    {
        if ($this->is_default) {
            if (($this->exists && ! $this->getOriginal('is_default')) || ! $this->exists) {
                self::with([])->where('model', $this->model)->update(['is_default' => false]);
            }
        }

        return parent::save($options);
    }

    public static function getFiltered($data, $modelColumns)
    {
        return collect($data)->map(function ($view) use ($modelColumns) {
            $content = $view->content;
            $filterSet = collect($content['filters']['filterSet'])->filter(function ($filter) {
                if (empty($filter['data_type'])) {
                    return true;
                }

                /*
                 * TODO: This is a lot of processing to determine if a table view is still valid.  We should just have a
                 *  job that runs periodically to clean up invalid table views.
                 */
                return true;
                //return $filter['data_type']::where('id', $filter['data_id'])->exists();
            })->toArray();

            $content['filters']['filterSet'] = $filterSet;

            $content['columns'] = collect($content['columns'])->filter(function ($column) use ($modelColumns) {
                if (isset($column['data_type'])) {
                    /*
                 * TODO: This is a lot of processing to determine if a table view is still valid.  We should just have a
                 *  job that runs periodically to clean up invalid table views.
                 */
                    return true;
                    //return $column['data_type']::where('id', $column['data_id'])->exists();
                }
                if (count($modelColumns) == 0) {
                    return true;
                }

                return in_array($column['value'], $modelColumns);
            })->toArray();

            $view->content = $content;
            $view->save();

            return $view;
        });
    }
}
