<?php

namespace App\Models;

use App\Models\Concerns\HasFilters;
use App\Models\Contracts\Filterable;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\Pivot;

/**
 * Class SupplierProductPricing.
 *
 *
 * @property int $id
 * @property int $supplier_pricing_tier_id
 * @property int $supplier_product_id
 * @property float $price
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 */
class SupplierProductPricing extends Pivot implements Filterable
{
    use HasFactory, HasFilters;

    protected $table = 'supplier_product_pricing';

    protected $casts = [
        'price' => 'float',
    ];

    protected $fillable = ['supplier_product_id', 'supplier_pricing_tier_id', 'price'];

    /*
    |--------------------------------------------------------------------------
    | Relations
    |--------------------------------------------------------------------------
    */

    public function supplierPricingTier()
    {
        return $this->belongsTo(SupplierPricingTier::class);
    }

    public function supplierProduct()
    {
        return $this->belongsTo(SupplierProduct::class);
    }

    /**
     * {@inheritDoc}
     */
    public function availableColumns()
    {
        return ['price'];
    }

    /**
     * {@inheritDoc}
     */
    public function filterableColumns(): array
    {
        return $this->availableColumns();
    }

    /**
     * {@inheritDoc}
     */
    public function generalFilterableColumns(): array
    {
        return $this->availableColumns();
    }
}
