<?php

namespace App\Models\Starshipit;

use App\Models\SalesOrderFulfillment;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Order.
 *
 *
 * @property int $order_id
 * @property string $order_date
 * @property string $order_number
 * @property string $reference
 * @property string $carrier
 * @property string $carrier_name
 * @property string $carrier_service_code
 * @property string $shipping_method
 * @property bool $signature_required
 * @property bool $dangerous_goods
 * @property array $destination
 * @property array $items
 * @property array $packages
 * @property int $declared_value
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property int $sku_fulfillment_id
 * @property array $errors
 * @property array $shipment
 * @property-read SalesOrderFulfillment $salesOrderFulfillment
 */
class StarshipitOrder extends Model
{
    protected $fillable = [
        'sku_fulfillment_id',
        'json_object',
    ];

    protected $casts = [
        'rawOrder' => 'json',
        'json_object' => 'json',
        'items' => 'array',
        'packages' => 'array',
    ];

    protected $table = 'starshipit_orders';

    public function salesOrderFulfillment()
    {
        return $this->belongsTo(SalesOrderFulfillment::class, 'sku_fulfillment_id');
    }
}
