<?php

namespace App\Models\Shopify;

use App\Models\IntegrationInstance;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * @property int $id
 * @property int $integration_instance_id
 * @property string $topic
 * @property string $unique_id
 * @property Carbon $payload_date
 * @property Carbon|null $processed_at
 * @property array $json_data
 * @property-read Carbon|null $updated_at
 * @property-read Carbon $created_at
 */
class ShopifyWebhookEvent extends Model
{
    use HasFactory;

    protected $table = 'shopify_webhook_events';

    const TOPIC_ORDERS = 'orders';

    protected $fillable = [
        'integration_instance_id',
        'topic',
        'unique_id',
        'payload_date',
        'processed_at',
        'json_data',
    ];

    /*
    |--------------------------------------------------------------------------
    | Relations
    |--------------------------------------------------------------------------
     */

    public function integrationInstance(): BelongsTo
    {
        return $this->belongsTo(IntegrationInstance::class);
    }
}
