<?php

namespace App\Models\Shopify;

use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Location.
 *
 * @property int $integration_instance_id
 * @property array $json_data
 * @property-read int $shopify_id
 * @property-read string $name
 * @property-read bool $active
 */
class ShopifyLocation extends Model
{
    protected $table = 'shopify_locations';

    protected $fillable = [
        'integration_instance_id',
        'json_data',
    ];

    protected $casts = [
        'json_data' => 'array',
    ];

    public function active(): Attribute
    {
        return Attribute::get(fn () => $this->json_data['active']);
    }
}
