<?php

namespace App\Models\Shopify;

use Illuminate\Database\Eloquent\Model;

/**
 * Class ShopifyEvent.
 *
 * @property int $subject_id
 * @property string $subject_type
 * @property string $verb
 * @property string|null $body
 * @property string|null $message
 * @property string|null $author
 * @property string|null $description
 * @property string|null $path
 * @property \Illuminate\Support\Carbon|null $processed_at
 * @property \Illuminate\Support\Carbon|null $sku_processed_at
 */
class ShopifyEvent extends Model
{
    protected $table = 'shopify_events';

    protected $fillable
        = [
            'subject_id',
            'subject_type',
            'verb',
            'body',
            'message',
            'author',
            'description',
            'path',
            'processed_at',
            'sku_processed_at',
        ];

    protected $casts
        = [
            'body' => 'array',
            'processed_at' => 'datetime',
            'sku_processed_at' => 'datetime',
        ];
}
