<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

/**
 * Class ShippingMethodMappingsSkuToShippingProviderMethod.
 *
 *
 * @property int $id
 * @property int $shipping_method_id
 * @property int $shipping_provider_id
 * @property string|null $shipping_provider_carrier
 * @property string $shipping_provider_method
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property-read string $full_name
 *
 * @method Builder|self whereFullName($value)
 */
class ShippingMethodMappingsSkuToShippingProviderMethod extends Model
{
    protected $table = 'shipping_method_mappings_sku_to_shipping_provider_method';

    protected $fillable = ['shipping_provider_id', 'shipping_provider_carrier', 'shipping_provider_method'];

    /*
    |--------------------------------------------------------------------------
    | Relations
    |--------------------------------------------------------------------------
    */

    public function shippingMethod()
    {
        return $this->belongsTo(ShippingMethod::class);
    }

    public function shippingProvider()
    {
        return $this->belongsTo(IntegrationInstance::class);
    }

    public function getFullNameAttribute()
    {
        return "{$this->shipping_provider_carrier} {$this->shipping_provider_method}";
    }

    public function scopeWhereFullName(Builder $builder, $value)
    {
        return $builder->whereRaw("concat(`shipping_provider_carrier`,' ',`shipping_provider_method`) = '{$value}'");
    }
}
