<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class ShippingMethodMappingsSalesChannelToSku.
 *
 *
 * @property int $id
 * @property int $sales_channel_id
 * @property string $sales_channel_method
 * @property int $shipping_method_id
 * @property ShippingMethod|null $shippingMethod
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 */
class ShippingMethodMappingsSalesChannelToSku extends Model
{
    protected $table = 'shipping_method_mappings_sales_channel_to_sku';

    protected $fillable = ['sales_channel_id', 'sales_channel_method', 'shipping_method_id'];

    /*
    |--------------------------------------------------------------------------
    | Relations
    |--------------------------------------------------------------------------
    */

    public function salesChannel()
    {
        return $this->belongsTo(SalesChannel::class);
    }

    public function shippingMethod()
    {
        return $this->belongsTo(ShippingMethod::class);
    }
}
