<?php

namespace App\Models;

use App\Models\Concerns\HasFilters;
use App\Models\Contracts\Filterable;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

/**
 * Class ShippingCarrier.
 *
 *
 * @property int $id
 * @property string $name
 * @property string|null $tracking_link
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 */
class ShippingCarrier extends Model implements Filterable
{
    use HasFactory;
    use HasFilters;

    protected $fillable = ['name', 'tracking_link'];

    protected $hidden = ['created_at', 'updated_at'];

    /*
    |--------------------------------------------------------------------------
    | Relations
    |--------------------------------------------------------------------------
    */

    public function shippingMethods(): HasMany
    {
        return $this->hasMany(ShippingMethod::class);
    }

    /*
    |--------------------------------------------------------------------------
    | Functions
    |--------------------------------------------------------------------------
    */

    public function delete(): ?bool
    {
        $this->shippingMethods()->delete();

        return parent::delete();
    }

    public function availableColumns(): array
    {
        return ['name'];
    }

    public function filterableColumns(): array
    {
        return $this->availableColumns();
    }

    public function generalFilterableColumns(): array
    {
        return $this->availableColumns();
    }
}
