<?php

namespace App\Models\ShipStation;

use App\Models\SalesOrderFulfillment;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * Class ShipstationOrder.
 *
 *
 * @property int $sku_fulfillment_id
 * @property int $orderId
 * @property string $orderNumber
 * @property string $orderKey
 * @property string $orderDate
 * @property string $createDate
 * @property string $modifyDate
 * @property array $shipment
 * @property array $json_data
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property-read SalesOrderFulfillment $salesOrderFulfillment
 */
class ShipstationOrder extends Model
{
    protected $table = 'shipstation_orders';

    protected $guarded = [];

    protected $casts = [
        'json_data' => 'array',
        'shipment' => 'array',
    ];

    public function salesOrderFulfillment(): BelongsTo
    {
        return $this->belongsTo(SalesOrderFulfillment::class, 'sku_fulfillment_id');
    }
}
