<?php

namespace App\Models;

use Illuminate\Support\Facades\Redis;

class SalesChannelsStateRedis
{
    /**
     * Redis connection name.
     *
     * @var string
     */
    public static $connection = 'default';

    /**
     * Name of group or collection.
     *
     * @var string
     */
    public static $collection = 'sales_channels_states';

    /**
     * Update or Create state key.
     */
    public static function updateOrCreate(string $state, array $data)
    {
        Redis::connection(self::$connection)->hmset(self::$collection.':'.$state, $data);
    }

    /**
     * @return null|array if state exists return array of data, Otherwise returns NULL.
     */
    public static function find(string $state): ?array
    {
        return Redis::connection(self::$connection)->hgetall(self::$collection.':'.$state);
    }
}
