<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Relations\Pivot;

/**
 * Class ProductToAttributeGroup.
 *
 *
 * @property int $id
 * @property int $product_id
 * @property int $attribute_group_id
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 */
class ProductToAttributeGroup extends Pivot
{
    protected $table = 'products_to_attribute_groups';

    protected $touches = ['product'];

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function attributeGroup()
    {
        return $this->belongsTo(AttributeGroup::class);
    }
}
