<?php

namespace App\Models;

use App\Abstractions\UniqueFieldsInterface;
use App\Models\Concerns\BulkImport;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\Pivot;

/**
 * Class ProductPricing.
 *
 *
 * @property int $id
 * @property int $product_pricing_tier_id
 * @property int $product_id
 * @property float $price
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 */
class ProductPricing extends Pivot implements UniqueFieldsInterface
{
    use BulkImport, HasFactory;

    protected $table = 'product_pricing';

    protected $casts = ['price' => 'float'];

    protected $fillable = ['product_id', 'product_pricing_tier_id', 'price'];

    protected $touches = ['product'];

    public static function getUniqueFields(): array
    {
        return ['product_pricing_tier_id', 'product_id'];
    }

    public function save(array $options = [])
    {
        $save = parent::save($options);

        if ($save) {
            ProductListing::where('product_id', $this->product_id)
                ->where('product_pricing_tier_id', $this->product_pricing_tier_id)
                ->update(['price' => $this->price]);
        }

        return $save;
    }

    /**
     * Relations.
     */
    public function productPricingTier()
    {
        return $this->belongsTo(ProductPricingTier::class);
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }
}
