<?php

namespace App\Models;

use App\Models\Concerns\BulkImport;
use App\Models\Concerns\HasFilters;
use App\Models\Contracts\Filterable;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

/**
 * Class ProductInventory.
 *
 *
 * @property int $id
 * @property int $product_id
 * @property int|null $warehouse_id
 * @property float $inventory_total
 * @property float $inventory_reserved
 * @property float $inventory_in_transit
 * @property float $inventory_available
 * @property float $inventory_stock_value
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 */
class ProductInventory extends Model implements Filterable
{
    use BulkImport;
    use HasFactory;
    use HasFilters;
    use Upsert;

    public static $idForTotalWarehouses = 0;

    protected $table = 'products_inventory';

    protected $fillable = [
        'product_id',
        'warehouse_id',
        'inventory_available',
        'inventory_reserved',
        'inventory_total',
        'inventory_stock_value',
    ];

    /*
    |--------------------------------------------------------------------------
    | Relations
    |--------------------------------------------------------------------------
    */
    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function warehouse()
    {
        return $this->belongsTo(Warehouse::class);
    }

    public function availableColumns()
    {
        return ['inventory_total', 'inventory_available'];
    }

    public function filterableColumns(): array
    {
        return $this->availableColumns();
    }

    public function generalFilterableColumns(): array
    {
        return $this->filterableColumns();
    }
}
