<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\MorphOne;
use Illuminate\Database\Eloquent\Relations\Pivot;
use Illuminate\Support\Carbon;

/**
 * Class ProductComponent
 *
 * @property int $id
 * @property int $parent_product_id
 * @property int $component_product_id
 * @property int $quantity
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property-read Product $parentProduct
 * @property-read Product $childProduct
 */
class ProductComponent extends Pivot
{
    protected $casts
        = [
            'quantity' => 'float',
        ];

    protected $table = 'product_components';

    protected $fillable = [
        'parent_product_id',
        'component_product_id',
        'quantity',
    ];

    /**
     * Relations.
     */
    public function inventoryMovement(): MorphOne
    {
        return $this->morphOne(InventoryMovement::class, 'link');
    }

    public function parentProduct(): BelongsTo
    {
        return $this->belongsTo(Product::class, 'parent_product_id');
    }

    public function childProduct(): BelongsTo
    {
        return $this->belongsTo(Product::class, 'component_product_id');
    }
}
