<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class ProductBlemished.
 *
 *
 * @property int $id
 * @property int $product_id
 * @property int $derived_from_product_id
 * @property string $condition
 * @property string|null $reference
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 */
class ProductBlemished extends Model
{
    protected $table = 'products_blemished';

    protected $guarded = [];

    /*
    |--------------------------------------------------------------------------
    | Relations
    |--------------------------------------------------------------------------
    */

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function originalProduct()
    {
        return $this->belongsTo(Product::class, 'derived_from_product_id');
    }
}
