<?php

namespace App\Models;

use App\Abstractions\UniqueFieldsInterface;
use App\Models\Concerns\BulkImport;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\Pivot;

/**
 * Class ProductAttribute.
 *
 *
 * @property int $product_id
 * @property int $attribute_id
 * @property mixed|null $value
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 */
class ProductAttribute extends Pivot implements UniqueFieldsInterface
{
    use BulkImport;
    use HasFactory;

    protected $table = 'product_attributes';

    protected $fillable = ['value', 'attribute_group_id', 'attribute_id', 'product_id'];

    protected $touches = ['product'];

    public static function getUniqueFields(): array
    {
        return ['product_id', 'attribute_id'];
    }

    public function setValueCast($type)
    {
        switch ($type) {
            case 'checkbox':
                $type = 'boolean';
                break;
        }

        $this->casts = ['value' => $type];
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function attribute()
    {
        return $this->belongsTo(Attribute::class);
    }

    public function attributeGroup()
    {
        return $this->belongsTo(AttributeGroup::class);
    }
}
