<?php

namespace App\Models;

use App\Abstractions\UniqueFieldsInterface;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphTo;

/**
 * Class OrderLink.
 *
 *
 * @property int $id
 * @property int $parent_id
 * @property string $parent_type
 * @property int $child_id
 * @property string $child_type
 * @property string $link_type
 * @property Carbon|null $created_at
 * @property Carbon|null $update_at
 * @property Model $child
 * @property-read string $link_name
 */
class OrderLink extends Model implements UniqueFieldsInterface
{
    use HasFactory;

    protected $guarded = [];

    const LINK_TYPE_DROPSHIP = 'dropship';

    const LINK_TYPE_RESEND = 'resend';

    const LINK_TYPE_EXCHANGE = 'exchange';

    public static function getUniqueFields(): array
    {
        return [
            'parent_id',
            'parent_type',
            'child_id',
            'child_type',
            'link_type',
        ];
    }

    public function parent(): MorphTo
    {
        return $this->morphTo();
    }

    public function child(): MorphTo
    {
        return $this->morphTo();
    }

    public function setChildAttribute(Model $value)
    {
        $this->child_id = $value->getKey();
        $this->child_type = $value->getMorphClass();
    }

    /**
     * @return mixed|null
     */
    public function getLinkNameAttribute()
    {
        return ucwords(str_replace('_', ' ', $this->link_type));
    }
}
