<?php

namespace App\Models\Magento;

use App\Models\IntegrationInstance;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

/**
 * @property int $id
 * @property int $attribute_id
 * @property int $integration_instance_id
 * @property array $json_object
 * @property-read string $code
 * @property-read string $type
 * @property-read array $options
 * @property-read string $label
 * @property-read bool $is_user_defined
 */
class ProductAttribute extends Model
{
    use HasFactory;

    protected $table = 'magento_product_attributes';

    protected $casts = ['json_object' => 'array', 'options' => 'array'];

    protected $fillable = ['integration_instance_id', 'attribute_id', 'json_object'];

    public function integrationInstance()
    {
        return $this->belongsTo(IntegrationInstance::class);
    }
}
