<?php

namespace App\Models\Magento;

use App\Models\SalesOrderLine;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;

/**
 * @property int $id
 * @property int $magento_order_id
 * @property array $line_item
 * @property-read int $line_id
 * @property-read int $product_id
 */
class OrderLineItem extends Model
{
    use HasFactory;

    protected $table = 'magento_order_line_items';

    protected $casts = ['line_item' => 'array'];

    public function order()
    {
        return $this->belongsTo(Order::class, 'magento_order_id');
    }

    /**
     * when using this relation you should add another condition to check the correct line(by order id or by sales channel id)
     */
    public function salesOrderLine(): HasOne
    {
        return $this->hasOne(SalesOrderLine::class, 'sales_channel_line_id', 'line_id');
    }
}
