<?php

namespace App\Models;

use App\Models\Concerns\BulkImport;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

/**
 * Class InventorySnapshot.
 *
 *
 * @property int $id
 * @property int $product_id
 * @property Carbon $date
 * @property bool $is_cache_valid
 * @property float $inventory_reserved
 * @property float $inventory_stock_value
 * @property float $inventory_in_transit
 * @property float $inventory_available
 * @property bool $inventory_in_stock
 * @property-read int $inventory_total
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 */
class InventorySnapshot extends Model
{
    use BulkImport, HasFactory;

    protected $casts = [
        'date' => 'datetime',
        'is_cache_valid' => 'boolean',
        'inventory_in_stock' => 'boolean',
    ];

    protected $fillable = [
        'product_id',
        'date',
        'is_cache_valid',
        'inventory_reserved',
        'inventory_stock_value',
        'inventory_in_transit',
        'inventory_available',
        'inventory_in_stock',
    ];

    /*
    |--------------------------------------------------------------------------
    | Relationships
    |--------------------------------------------------------------------------
    */

    public function products(): HasMany
    {
        return $this->hasMany(Product::class);
    }

    /*
    |--------------------------------------------------------------------------
    | Accessors & Mutators
    |--------------------------------------------------------------------------
    */

    public function inventoryTotal(): Attribute
    {
        return Attribute::get(
            fn () => $this->inventory_available +
                $this->inventory_reserved +
                $this->inventory_in_transit
        );
    }
}
