<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class IntegrationShippingMethod.
 *
 *
 * @property int id
 * @property int integration_instance_id
 * @property string code
 * @property bool is_domestic
 * @property int shipping_method_id
 * @property array metadata
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 */
class IntegrationShippingMethod extends Model
{
    protected $fillable = ['integration_instance_id', 'code', 'is_domestic', 'shipping_method_id', 'metadata'];

    protected $casts = ['metadata' => 'array', 'is_domestic' => 'boolean'];

    /*
    |--------------------------------------------------------------------------
    | Relations
    |--------------------------------------------------------------------------
    */

    public function shippingMethod()
    {
        return $this->belongsTo(ShippingMethod::class);
    }
}
