<?php
/**
 * Created by PhpStorm.
 * User: brightantwiboasiako
 * Date: 8/27/20
 * Time: 3:06 PM.
 */

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * Trait HasParent.
 *
 * @property string $link_type
 * @property Model $link
 */
trait HasParentLink
{
    /**
     * Gets the parent link id attribute of the linked model.
     *
     * @return int|mixed|null
     */
    public function getParentLinkIdAttribute()
    {
        if (! $this->link_type || ! class_exists($this->link_type)) {
            return null;
        }

        if ($this->link instanceof SalesOrderLine) {
            return $this->link->sales_order_id ?? null;
        } elseif ($this->link instanceof PurchaseOrderLine) {
            return $this->link->purchase_order_id ?? null;
        } elseif ($this->link instanceof PurchaseOrderShipmentLine) {
            return $this->link->purchaseOrderLine->purchase_order_id ?? null;
        } elseif ($this->link instanceof PurchaseOrderShipmentReceiptLine) {
            return $this->link->purchaseOrderShipmentLine->purchaseOrderLine->purchase_order_id ?? null;
        } elseif ($this->link instanceof PurchaseInvoiceLine) {
            return $this->link->purchaseOrderLine->purchase_order_id ?? null;
        } elseif ($this->link instanceof SalesOrderFulfillmentLine) {
            return $this->link->salesOrderLine->sales_order_id ?? null;
        } elseif ($this->link instanceof WarehouseTransferShipmentLine) {
            return $this->link->warehouseTransferLine->warehouse_transfer_id ?? null;
        } elseif ($this->link instanceof WarehouseTransferLine) {
            return $this->link->warehouse_transfer_id ?? null;
        } elseif ($this->link instanceof WarehouseTransferShipmentReceiptLine) {
            return $this->link->shipmentLine->warehouseTransferLine->warehouse_transfer_id ?? null;
        } elseif ($this->link instanceof StockTakeItem) {
            return $this->link->stock_take_id ?? null;
        } elseif ($this->link instanceof SalesCreditLine) {
            return $this->link->sales_credit_id;
        } elseif ($this->link instanceof SalesCreditReturnLine) {
            return $this->link->salesCreditLine->sales_credit_id;
        } elseif ($this->link instanceof InventoryAssemblyLine) {
            return $this->link->inventoryAssembly->id ?? null;
        }

        return null;
    }

    public function getParentLink()
    {
        if (! $this->link_type || ! class_exists($this->link_type)) {
            return null;
        }

        if ($this->link instanceof SalesOrderLine) {
            return $this->link?->salesOrder;
        } elseif ($this->link instanceof PurchaseOrderLine) {
            return $this->link?->purchaseOrder;
        } elseif ($this->link instanceof PurchaseOrderShipmentLine) {
            return $this->link?->purchaseOrderLine?->purchaseOrder;
        } elseif ($this->link instanceof PurchaseOrderShipmentReceiptLine) {
            return $this->link?->purchaseOrderShipmentLine?->purchaseOrderLine?->purchaseOrder;
        } elseif ($this->link instanceof PurchaseInvoiceLine) {
            return $this->link?->purchaseOrderLine?->purchaseOrder;
        } elseif ($this->link instanceof SalesOrderFulfillmentLine) {
            return $this->link?->salesOrderLine?->salesOrder;
        } elseif ($this->link instanceof WarehouseTransferShipmentLine) {
            return $this->link?->warehouseTransferLine?->warehouseTransfer;
        } elseif ($this->link instanceof WarehouseTransferLine) {
            return $this->link?->warehouseTransfer;
        } elseif ($this->link instanceof WarehouseTransferShipmentReceiptLine) {
            return $this->link?->shipmentLine?->warehouseTransferLine?->warehouseTransfer;
        } elseif ($this->link instanceof StockTakeItem) {
            return $this->link?->stockTake;
        } elseif ($this->link instanceof SalesCreditLine) {
            return $this->link?->salesCredit;
        } elseif ($this->link instanceof SalesCreditReturnLine) {
            return $this->link?->salesCreditLine?->salesCredit;
        } elseif ($this->link instanceof InventoryAssemblyLine) {
            return $this->link?->inventoryAssembly;
        }

        return null;
    }
}
