<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ForecastItemPOLineLink extends Model
{
    use HasFactory;

    protected $table = 'forecast_item_po_line_links';

    protected $fillable = [
        'forecast_item_id',
        'purchase_order_line_id',
    ];

    public function forecastItem(): BelongsTo
    {
        return $this->belongsTo(InventoryForecastItem::class, 'forecast_item_id');
    }

    public function purchaseOrderLine(): BelongsTo
    {
        return $this->belongsTo(PurchaseOrderLine::class, 'purchase_order_line_id');
    }
}
