<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

/**
 * @property int $id
 * @property string $name
 * @property Carbon $created_at
 * @property ?Carbon $updated_at
 * @property ?Carbon $archived_at
 * @property-read FinancialAlert[] $financialAlerts
 */
class FinancialAlertClassification extends Model
{
    use HasFactory;

    protected $guarded = [];

    protected $casts = [
        'archived_at' => 'datetime',
    ];

    /*
    |--------------------------------------------------------------------------
    | Relations
    |--------------------------------------------------------------------------
    */

    public function financialAlerts(): HasMany
    {
        return $this->hasMany(FinancialAlert::class);
    }
}
