<?php

namespace App\Models\Ebay;

use App\Models\SalesOrder;
use DTS\eBaySDK\Trading\Enums\OrderStatusCodeType;
use DTS\eBaySDK\Trading\Types\OrderType;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Order.
 *
 *
 * @property int $sku_sales_order_id
 * @property array $normalized_section
 * @property array $raw_order
 */
class Order extends Model
{
    protected $guarded = [];

    /**
     * Map eBay order Status with Local.
     * Return Local Status.
     */
    public static function statusMap(OrderType $ebay_object): string
    {
        switch ($ebay_object->OrderStatus) {
            case OrderStatusCodeType::C_ACTIVE:
                return SalesOrder::STATUS_DRAFT;
            case OrderStatusCodeType::C_IN_PROCESS:
                return SalesOrder::STATUS_OPEN;
            case OrderStatusCodeType::C_COMPLETED:
                return SalesOrder::STATUS_CLOSED;
            case OrderStatusCodeType::C_CANCELLED:
                return SalesOrder::STATUS_CLOSED;
            default:
                return SalesOrder::STATUS_DRAFT;
        }
    }
}
