<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\MorphTo;

/**
 * @property int $id
 * @property int $custom_field_id
 * @property string $link_type
 * @property int $link_id
 * @property string $value
 * @property Carbon $created_at
 * @property ?Carbon $updated_at
 * @property-read CustomField $customField
 * @property-read Model $link
 */
class CustomFieldValue extends Model
{
    use HasFactory;

    protected $guarded = [];

    /*
    |--------------------------------------------------------------------------
    | Relationships
    |--------------------------------------------------------------------------
    */
    public function customField(): BelongsTo
    {
        return $this->belongsTo(CustomField::class);
    }

    public function link(): MorphTo
    {
        return $this->morphTo('link');
    }
}
