<?php

namespace App\Models\Contracts;

interface Filterable
{
    /**
     * Get available columns to show in datatable.
     *
     * @return array
     */
    public function availableColumns();

    /**
     * Get filterable columns, must be inside available columns.
     */
    public function filterableColumns(): array;

    /**
     * Get General filterable columns.
     */
    public function generalFilterableColumns(): array;
}
