<?php

namespace App\Models\Constant;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class ConstantsContinent extends Model
{
    protected $table = 'constants_continents';

    public $timestamps = false;

    protected $with = ['children'];

    protected $fillable = [
        'code',
        'name',
        'continent_code',
    ];

    public function children(): HasMany
    {
        return $this->hasMany(ConstantsCountry::class, 'continent_name', 'name');
    }
}
