<?php

namespace App\Models\Concerns\SalesOrder;

use App\Models\PurchaseOrder;
use App\Models\Warehouse;
use App\Services\SalesOrder\WarehouseRoutingMethod;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

trait HasDropship
{
    public function dropshipLines(): HasMany
    {
        return $this->warehousedProductLines()
            ->where('warehouse_routing_method', WarehouseRoutingMethod::DROPSHIP);
    }

    public function hasDropshipOrders(): bool
    {
        return $this->purchaseOrders()->count() > 0;
    }

    public function removeUnsubmittedPurchaseOrders(): self
    {
        $this->purchaseOrders()
            ->where('submission_status', PurchaseOrder::SUBMISSION_STATUS_UNSUBMITTED)
            ->each(fn (PurchaseOrder $purchaseOrder) => $purchaseOrder->delete());

        return $this;
    }

    public function getDropshipOrderAtWarehouse(Warehouse|int $warehouse): PurchaseOrder|Model|null
    {
        $warehouseId = is_numeric($warehouse) ? $warehouse : $warehouse->id;

        return $this->purchaseOrders()->where('destination_warehouse_id', $warehouseId)->first();
    }

    public function syncDropshipOrders(array $dropshipOrders): void
    {
        $this->purchaseOrders()->whereNotIn('id', $dropshipOrders)
            ->where('submission_status', PurchaseOrder::SUBMISSION_STATUS_UNSUBMITTED)
            ->delete();
    }
}
